#ifndef APP_EVENTS_H
#define APP_EVENTS_H

// Zdarzenie postepu menu
PROGRESS(MenuProgress)
{
	// konczymy gre po wcisnieciu klawisza ESCAPE
	if( XE_IO::KeyboardGetPressed( XE_KEY_ESC ) ) Game.Exit();

	// aktualizujemy kamere
	Game.Camera.Update();

	// postep gry
	Game.Progress();

	// wyrzucamy wszystko na ekran, czyscimy bufor koloru oraz resetujemy transformacje
	XeRenderScene( XE_FLAG_SWAP | XE_FLAG_COLORBUFF | XE_FLAG_TRANSFORMIDENT );
}

// Zdarzenie sceny menu
SCENE(MenuScene)
{
	Room = 0;
	Map = 1; // resetujemy aktualnie odpalon map
	// zmieniamy ustawienia okna i aktualizujemy je
	Game.Windows( "main" )->Width = 800;	// szerokosc
	Game.Windows( "main" )->Height = 600;	// wysokosc
	Game.WindowCentralize( "main" );		// wycentrowanie okna
	Game.Windows( "main" )->Update();		// aktualizacja
	Game.OnWindowSetup( "main" );			// dostosowanie renderera do nowych wlasciwosci okna
	Game.Vsync( false );					// wycza Vsync	

	// rozmiar kamery taki sam jak rozmiar okna
	Game.Camera.Width = (float)Game.Windows( "main" )->Width;
	Game.Camera.Height = (float)Game.Windows( "main" )->Height;

	// czcionka
	Game.Fonts( "main" )->Prepare( "Resources/Fonts/courier_new.xet", "Resources/Fonts/courier_new.fnt", 10, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	// ikonka
	Game.Sprites( "GB1" )->Prepare( "Resources/Images/Bubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );

	// podpinamy interfejs pod okno
	Game.GUI.Setup( Game.Windows( "main" ).iPointer() );
	// podpinamy funkcje ladujaca obrazki formatu innego niz XET
	Game.GUI.CallbackLoadTextureOtherType = C_IMAGE::LoadTexture;
	// ladujemy motyw (style) kontrolek z pliku XML
	Game.GUI.LoadTheme(
		"Resources/Gui/Custom.xml",	// sciezka do pliku motywu
		"Custom"						// nazwa motywu do wczytania
		);

	// kontener procedur obslugi zdarzen
	XE_CONTAINER<C_GUI_EVENT> proc;
	// dodajemy procedury do kontenera
	proc.Access( "MainWindow" ) = MainWindowDoEvents;
	proc.Access( "Button" ) = ButtonsDoEvents;
	// kontener tekstur
	XE_CONTAINER<XE_ELM_TEXTURE> tex;
	// dodajemy tekstury do kontenera
	tex.Access( "MainIcon" ) = Game.Sprites( "GB1" )->GetCurrent();
	// ladujemy schemat interfejsu z pliku XML
	C_GUI_LOADER::LoadScheme(
		"Resources/Gui/Scheme.xml",	// sciezka do pliku XML schematu
		"Root",						// wezel glowny z ktorego ladujemy kontrolki
		proc,						// referencja na kontener procedur
		tex,						// referencja na kontener tekstur
		Game.GUI					// referencja na obiekt interfejsu
		);
	// czyscimy kontenery
	proc.Clear();
	tex.Clear();

	// wykonanie zdarzenia postepu gry
	XE_EVENTS::Execute( MenuProgress );

	// czyscimy po sobie
	Game.Cleanup();
	Game.Sprites.Clear();
	Game.Fonts.Clear();
}

// Zdarzenie postepu gry
PROGRESS(GameProgress)
{
	// wracamy do menu po kliknieciu ESC, oraz gdy liczba ruchw jest rwna -10 ( Moves jest rwne -10 gdy nie uda si zaadowa mapki )
	if( XE_IO::KeyboardGetPressed( XE_KEY_ESC ) || Moves == -10 ) Game.GoToScene( "menu" );
	// aktualizujemy kamere
	Game.Camera.Update();

	// przyspieszenie przez klawisz CTRL 
	if( XE_IO::KeyboardGet( XE_KEY_CTRL ) )
		TimeSpeed += 2.0f * XE_EVENTS::Use().DeltaTime;
	else
		TimeSpeed -= 2.0f * XE_EVENTS::Use().DeltaTime;
	if( TimeSpeed < 1.0f ) TimeSpeed = 1.0f;
	if( TimeSpeed > 2.0f ) TimeSpeed = 2.0f;
	GameSpeed = TimeSpeed * XE_EVENTS::Use().DeltaTime;

	// kasowanie
	if( XE_IO::MouseGetPressed( XE_MOUSE_LEFT ) )
	{
		// sprawdza czy istnieje juz jakis obiekt w danej komorce siatki
		XE_ACTOR* coll = 0;
		XE_FOREACH( XE_ACTOR*, Game.Actors, elm )
		{
			if( Game.IsDescribedAs( elm(), "CB1" ) || Game.IsDescribedAs( elm(), "CB2" ) || Game.IsDescribedAs( elm(), "CB3" ) )
				if( RectCollision( Game.MouseGetPos( "main" ) + XE_VECTOR( 16, 16 ), elm()->Position, elm()->Position + XE_VECTOR( 32, 32 ) ) )
				{
					coll = elm();
					break;
				}
		}
		// niszczenie obiektu jesli istnieje w danej komorce siatki, a liczba ruchw jest wiksza od 0
		if( coll && Moves > 0 ) {
			Game.UnregisterActor( coll );
			Moves -= 1; // odejmujemy ilo pozostaych ruchw
			Game.Audio.SoundPlay( Sounds.Access( "1" ) ); // odtwarzamy dwik
		}
		if ( !coll ) { // jeli nie ma adnego obiektu w danej komorce siatki, sprawdzamy wygran/przegran
			// jeli nie mamy ju adnych ruchw, a na mapie s jeszcze due bbelki, a nie ma maych to gracz przegra
			if ( Moves == 0 && Game.Actors.Count("CSB1") == 0 && (Game.Actors.Count("CB1") > 0 || Game.Actors.Count("CB2") > 0 || Game.Actors.Count("CB3") > 0 )) {
				if ( Map == 1 ) // jeli aktualna mapa to pierwsza, przechodzimy do menu
					Game.GoToScene( "menu" );
				else // jesli nie, restartujemy poziom
					Game.GoToScene( "game" );
			} // jeli jednak na mapie nie ma adnych duych bbelkw, gracz przechodzi do nastpnego poziomu 
			else if ( Game.Actors.Count("CB1") == 0 && Game.Actors.Count("CB2") == 0 && Game.Actors.Count("CB3") == 0 ) {
				Map = Map + 1;
				Game.GoToScene( "game" );
			}}
	}

	// postep gry
	Game.Progress();

	// FPS i moliwe ruchy
	XE_STRING str;
	str.Format( "FPS: %i\nRuchy: %i", (int)XE_EVENTS::Use().FPS, Moves); // to co bdziemy rysowa na ekranie ( tekst )
	Game.Fonts( "main" )->Draw( str, XE_VECTOR(10, 25 ), XE_VECTOR( 0.5, 0.5 ) ); // rysowanie

	// wyrzucamy wszystko na ekran, czyscimy bufor koloru oraz resetujemy transformacje
	XeRenderScene( XE_FLAG_SWAP | XE_FLAG_COLORBUFF | XE_FLAG_TRANSFORMIDENT );
}

// Zdarzenie sceny gry
SCENE(GameScene)
{
	Room = 1; // zmienia Room na 1, aby gra wiedziaa na ktrej scenie jestemy
	if ( Map == 1 ) { // jeli aktualnie wczytywana mapka to pierwsza, gracz musi wybra folder z mapami
		XE_STRING directory;
		directory = Game.GetDirname("Wybierz folder map",".\\Resources\\Maps\\",0,"Wybierz folder map",0); // wybieranie
		DSave = directory; // zapisanie do zmiennej
	}
	// zmieniamy ustawienia okna i aktualizujemy je
	Game.Windows( "main" )->Width = 800;	// szerokosc
	Game.Windows( "main" )->Height = 600;	// wysokosc
	Game.WindowCentralize( "main" );		// wycentrowanie okna
	Game.Windows( "main" )->Update();		// aktualizacja
	Game.OnWindowSetup( "main" );			// dostosowanie renderera do nowych wlasciwosci okna
	Game.Vsync( false );					// wycza Vsync	

	// rozmiar kamery taki sam jak rozmiar okna
	Game.Camera.Width = (float)Game.Windows( "main" )->Width;
	Game.Camera.Height = (float)Game.Windows( "main" )->Height;

	// czcionka
	Game.Fonts( "main" )->Prepare( "Resources/Fonts/courier_new.xet", "Resources/Fonts/courier_new.fnt", 10, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	// ikonka
	Game.Sprites( "GB1" )->Prepare( "Resources/Images/Bubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	// dwiki
	Sounds.Access( "1" ) = Game.Audio.SoundAdd( "Resources/Sounds/1.mp3" );

	// podpinamy interfejs pod okno
	Game.GUI.Setup( Game.Windows( "main" ).iPointer() );
	// podpinamy funkcje ladujaca obrazki formatu innego niz XET
	Game.GUI.CallbackLoadTextureOtherType = C_IMAGE::LoadTexture;
	// ladujemy motyw (style) kontrolek z pliku XML
	Game.GUI.LoadTheme(
		"Resources/Gui/Custom.xml",	// sciezka do pliku motywu
		"Custom"						// nazwa motywu do wczytania
		);
	// kontener procedur obslugi zdarzen
	XE_CONTAINER<C_GUI_EVENT> proc;
	// dodajemy procedury do kontenera
	proc.Access( "MainWindow" ) = MainWindowDoEvents;
	// kontener tekstur
	XE_CONTAINER<XE_ELM_TEXTURE> tex;
	// dodajemy tekstury do kontenera
	tex.Access( "MainIcon" ) = Game.Sprites( "GB1" )->GetCurrent();
	// ladujemy schemat interfejsu z pliku XML
	C_GUI_LOADER::LoadScheme(
		"Resources/Gui/Scheme2.xml",	// sciezka do pliku XML schematu
		"Root",						// wezel glowny z ktorego ladujemy kontrolki
		proc,						// referencja na kontener procedur
		tex,						// referencja na kontener tekstur
		Game.GUI					// referencja na obiekt interfejsu
		);
	// czyscimy kontener
	tex.Clear();

	// obrazki
	Game.Sprites( "GB1" )->Prepare( "Resources/Images/Bubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB1" )->Centralize();
	Game.Sprites( "GB2" )->Prepare( "Resources/Images/Bubble2.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB2" )->Centralize();
	Game.Sprites( "GB3" )->Prepare( "Resources/Images/Bubble3.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB3" )->Centralize();
	Game.Sprites( "GSB1" )->Prepare( "Resources/Images/SBubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GSB1" )->Centralize();
	Game.Sprites( "Brick" )->Prepare( "Resources/Images/Brick.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "Brick" )->Centralize();
	Game.Sprites( "PUp" )->Prepare( "Resources/Images/PUp.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "PUp" )->Centralize();

	XE_STRING load; // aduje mapke
	load.Format( "%s/%i.map",DSave.Get(),Map);
	Editor.Load(load);

	// wykonanie zdarzenia postepu gry
	XE_EVENTS::Execute( GameProgress );

	// czyscimy po sobie
	Game.Cleanup();
	Game.Sprites.Clear();
	Game.Fonts.Clear();
	Sounds.Clear();
}

// Zdarzenie postepu pomocy
PROGRESS(TutorialProgress)
{
	// wracamy do menu po kliknieciu ESC, oraz gdy liczba ruchw jest rwna -10 ( Moves jest rwne -10 gdy nie uda si zaadowa mapki )
	if( XE_IO::KeyboardGetPressed( XE_KEY_ESC ) ) Game.GoToScene( "menu" );
	// aktualizujemy kamere
	Game.Camera.Update();

	// postep gry
	Game.Progress();

	// tekst pomocy
	XE_STRING str;
	str.Format( "Pomoc\nW grze nalezy pozbyc sie wszystkich babelkow znajdujacych sie na planszy.\nZielone babelki zbija sie jednym kliknieciem, niebieskie dwoma, a czerwone trzema.\nIstnieje takze babelek dodajacy nam jeden ruch.\n" 
		"Co czym robic?\nLewy przycisk myszy - niszczy babelek\nCTRL - szybsze tempo\nPo wyczysczyniu planszy, lub braku mozliwych ruchow nalezy kliknac lewy przycisk myszki" // dalsza cz tekstu
		); // to co bdziemy rysowa na ekranie ( tekst )
	Game.Fonts( "main" )->Draw( str, XE_VECTOR( 15, 240 ), XE_VECTOR( 0.5, 0.5 ) ); // rysowanie

	// wyrzucamy wszystko na ekran, czyscimy bufor koloru oraz resetujemy transformacje
	XeRenderScene( XE_FLAG_SWAP | XE_FLAG_COLORBUFF | XE_FLAG_TRANSFORMIDENT );
}

// Zdarzenie sceny pomocy
SCENE(TutorialScene)
{
	// zmieniamy ustawienia okna i aktualizujemy je
	Game.Windows( "main" )->Width = 800;	// szerokosc
	Game.Windows( "main" )->Height = 600;	// wysokosc
	Game.WindowCentralize( "main" );		// wycentrowanie okna
	Game.Windows( "main" )->Update();		// aktualizacja
	Game.OnWindowSetup( "main" );			// dostosowanie renderera do nowych wlasciwosci okna
	Game.Vsync( false );					// wycza Vsync	

	// rozmiar kamery taki sam jak rozmiar okna
	Game.Camera.Width = (float)Game.Windows( "main" )->Width;
	Game.Camera.Height = (float)Game.Windows( "main" )->Height;

	// czcionka
	Game.Fonts( "main" )->Prepare( "Resources/Fonts/courier_new.xet", "Resources/Fonts/courier_new.fnt", 10, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	// ikonka
	Game.Sprites( "GB1" )->Prepare( "Resources/Images/Bubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );

	// podpinamy interfejs pod okno
	Game.GUI.Setup( Game.Windows( "main" ).iPointer() );
	// podpinamy funkcje ladujaca obrazki formatu innego niz XET
	Game.GUI.CallbackLoadTextureOtherType = C_IMAGE::LoadTexture;
	// ladujemy motyw (style) kontrolek z pliku XML
	Game.GUI.LoadTheme(
		"Resources/Gui/Custom.xml",	// sciezka do pliku motywu
		"Custom"						// nazwa motywu do wczytania
		);
	// kontener procedur obslugi zdarzen
	XE_CONTAINER<C_GUI_EVENT> proc;
	// dodajemy procedury do kontenera
	proc.Access( "MainWindow" ) = MainWindowDoEvents;
	// kontener tekstur
	XE_CONTAINER<XE_ELM_TEXTURE> tex;
	// dodajemy tekstury do kontenera
	tex.Access( "MainIcon" ) = Game.Sprites( "GB1" )->GetCurrent();
	// ladujemy schemat interfejsu z pliku XML
	C_GUI_LOADER::LoadScheme(
		"Resources/Gui/Scheme2.xml",	// sciezka do pliku XML schematu
		"Root",						// wezel glowny z ktorego ladujemy kontrolki
		proc,						// referencja na kontener procedur
		tex,						// referencja na kontener tekstur
		Game.GUI					// referencja na obiekt interfejsu
		);
	// czyscimy kontener
	tex.Clear();

	// wykonanie zdarzenia postepu gry
	XE_EVENTS::Execute( TutorialProgress );

	// czyscimy po sobie
	Game.Cleanup();
	Game.Sprites.Clear();
	Game.Fonts.Clear();
}

// Zdarzenie postepu edytora
PROGRESS(EditorProgress)
{
	// konczymy gre po wcisnieciu klawisza ESCAPE
	if( XE_IO::KeyboardGetPressed( XE_KEY_ESC ) ) Game.GoToScene( "menu" );
	// aktualizujemy kamere
	Game.Camera.Update();

	Editor.Update();

	// postep gry
	Game.Progress();

	Editor.Render();

	// Aktorzy, FPS, Ruchy
	XE_STRING str;
	str.Format( "Aktorzy: %u\nFPS: %i\nRuchy: %i", Game.Actors.Count(), (int)XE_EVENTS::Use().FPS, Moves ); // to co bdziemy rysowa na ekranie ( tekst )
	Game.Fonts( "main" )->Draw( str, XE_VECTOR(10, 25 ), XE_VECTOR( 0.5, 0.5 ) ); // rysowanie

	// jeli klikamy S, to zapisujemy mapke
	if( XE_IO::KeyboardGetPressed( XE_KEY_S ) ) Editor.Save( Game.GetFilename( XEF_SAVE, "Game Map File (*.map)|*.map", "Zapisz mape", ".\\Resources\\Maps\\" ) << ".map" );
	// jeli klikamy L, to wczytujemy mapke
	if( XE_IO::KeyboardGetPressed( XE_KEY_L ) ) Editor.Load( Game.GetFilename( XEF_OPEN, "Game Map File (*.map)|*.map", "Wczytaj mape", ".\\Resources\\Maps\\" ) );

	// wyrzucamy wszystko na ekran, czyscimy bufor koloru oraz resetujemy transformacje
	XeRenderScene( XE_FLAG_SWAP | XE_FLAG_COLORBUFF | XE_FLAG_TRANSFORMIDENT );
}

// Zdarzenie sceny edytora
SCENE(EditorScene)
{
	Room = 2; // zmienia Room na 2, aby gra wiedziaa na ktrej scenie jestemy
	Moves = 1;
	Game.Message( "LPM = Po obiekt,\nPPM = Skasuj obiekt,\nKko myszki = Zmiana obiektu,\nPageUp/PageDown = Zmiana obiektu,\n+/- = Zmiana iloci ruchw,\nL = Wczytaj mape,\nS = Zapisz mape.", "Blast Me" );
	Game.Message( "Zapisujc map, nazywaj j kolejno 1, 2, 3, ... w jednym, wybranym folderze ktry jest nazw paczki map. Pamitaj, nie nadpisuj map!" );

	// zmieniamy ustawienia okna i aktualizujemy je
	Game.Windows( "main" )->Width = 800;	// szerokosc
	Game.Windows( "main" )->Height = 600;	// wysokosc
	Game.WindowCentralize( "main" );		// wycentrowanie okna
	Game.Windows( "main" )->Update();		// aktualizacja
	Game.OnWindowSetup( "main" );			// dostosowanie renderera do nowych wlasciwosci okna
	Game.Vsync( false );					// wycza Vsync	

	// rozmiar kamery taki sam jak rozmiar okna
	Game.Camera.Width = (float)Game.Windows( "main" )->Width;
	Game.Camera.Height = (float)Game.Windows( "main" )->Height;

	// czcionka
	Game.Fonts( "main" )->Prepare( "Resources/Fonts/courier_new.xet", "Resources/Fonts/courier_new.fnt", 10, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );

	// obrazki
	Game.Sprites( "GB1" )->Prepare( "Resources/Images/Bubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB1" )->Centralize();
	Game.Sprites( "GB2" )->Prepare( "Resources/Images/Bubble2.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB2" )->Centralize();
	Game.Sprites( "GB3" )->Prepare( "Resources/Images/Bubble3.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GB3" )->Centralize();
	Game.Sprites( "GSB1" )->Prepare( "Resources/Images/SBubble1.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "GSB1" )->Centralize();
	Game.Sprites( "Brick" )->Prepare( "Resources/Images/Brick.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "Brick" )->Centralize();
	Game.Sprites( "PUp" )->Prepare( "Resources/Images/PUp.xet", true, XE_TEXTURE_PARAM_LINEAR, XE_TEXTURE_PARAM_LINEAR );
	Game.Sprites( "PUp" )->Centralize();

	// podpinamy interfejs pod okno
	Game.GUI.Setup( Game.Windows( "main" ).iPointer() );
	// podpinamy funkcje ladujaca obrazki formatu innego niz XET
	Game.GUI.CallbackLoadTextureOtherType = C_IMAGE::LoadTexture;
	// ladujemy motyw (style) kontrolek z pliku XML
	Game.GUI.LoadTheme(
		"Resources/Gui/Custom.xml",	// sciezka do pliku motywu
		"Custom"						// nazwa motywu do wczytania
		);
	// kontener procedur obslugi zdarzen
	XE_CONTAINER<C_GUI_EVENT> proc;
	// dodajemy procedury do kontenera
	proc.Access( "MainWindow" ) = MainWindowDoEvents;
	// kontener tekstur
	XE_CONTAINER<XE_ELM_TEXTURE> tex;
	// dodajemy tekstury do kontenera
	tex.Access( "MainIcon" ) = Game.Sprites( "GB1" )->GetCurrent();
	// ladujemy schemat interfejsu z pliku XML
	C_GUI_LOADER::LoadScheme(
		"Resources/Gui/Scheme2.xml",	// sciezka do pliku XML schematu
		"Root",						// wezel glowny z ktorego ladujemy kontrolki
		proc,						// referencja na kontener procedur
		tex,						// referencja na kontener tekstur
		Game.GUI					// referencja na obiekt interfejsu
		);
	// czyscimy kontener
	tex.Clear();

	// czycimy stan klawiszy
	XE_IO::Clear(1);

	// wykonanie zdarzenia postepu gry
	XE_EVENTS::Execute( EditorProgress );

	// czyscimy po sobie
	Game.Cleanup();
	Game.Sprites.Clear();
	Game.Fonts.Clear();
}


#endif /* APP_EVENTS_H */
